

<?php $__env->startSection('title', 'Error Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="dashboard-header">
    <div class="d-flex justify-content-between align-items-center">
        <div>
            <h1>Error Details #<?php echo e($error->id); ?></h1>
            <p>
                <span class="status-badge status-<?php echo e($error->level_color); ?>"><?php echo e(strtoupper($error->level)); ?></span>
                <?php if($error->is_resolved): ?>
                    <span class="status-badge status-completed ml-2">Resolved</span>
                <?php else: ?>
                    <span class="status-badge status-pending ml-2">Unresolved</span>
                <?php endif; ?>
                <?php if($error->is_sent): ?>
                    <span class="status-badge status-info ml-2">
                        <i class="fas fa-paper-plane"></i> Sent to Support
                    </span>
                <?php endif; ?>
            </p>
        </div>
        <div>
            <a href="<?php echo e(route('admin.errors.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Back to List
            </a>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        
        <div class="dashboard-card mb-4">
            <div class="dashboard-card-header">
                <h3>Error Information</h3>
            </div>
            <div class="dashboard-card-body">
                <div class="form-group">
                    <label><strong>Type:</strong></label>
                    <code><?php echo e($error->type); ?></code>
                </div>

                <div class="form-group">
                    <label><strong>Message:</strong></label>
                    <div class="alert alert-danger">
                        <?php echo e($error->message); ?>

                    </div>
                </div>

                <div class="form-group">
                    <label><strong>File Location:</strong></label>
                    <code><?php echo e($error->file); ?></code>
                    <?php if($error->line): ?>
                        <span class="ml-2">Line: <strong><?php echo e($error->line); ?></strong></span>
                    <?php endif; ?>
                </div>

                <div class="form-group">
                    <label><strong>URL:</strong></label>
                    <div>
                        <span class="badge bg-primary"><?php echo e($error->method); ?></span>
                        <code><?php echo e($error->url); ?></code>
                    </div>
                </div>

                <div class="form-group">
                    <label><strong>IP Address:</strong></label>
                    <span><?php echo e($error->ip ?? 'Unknown'); ?></span>
                </div>

                <div class="form-group">
                    <label><strong>User Agent:</strong></label>
                    <small><?php echo e($error->user_agent ?? 'Unknown'); ?></small>
                </div>

                <div class="form-group">
                    <label><strong>Occurred:</strong></label>
                    <span><?php echo e($error->created_at->format('F d, Y \a\t H:i:s')); ?></span>
                    <small class="text-muted">(<?php echo e($error->created_at->diffForHumans()); ?>)</small>
                </div>
            </div>
        </div>

        
        <div class="dashboard-card mb-4">
            <div class="dashboard-card-header">
                <h3>Stack Trace</h3>
            </div>
            <div class="dashboard-card-body">
                <pre style="max-height: 400px; overflow-y: auto; background: #1e1e1e; color: #d4d4d4; padding: 1rem; border-radius: 4px; font-size: 0.85rem;"><?php echo e($error->trace); ?></pre>
            </div>
        </div>

        
        <?php if($error->context): ?>
        <div class="dashboard-card mb-4">
            <div class="dashboard-card-header">
                <h3>Context Data</h3>
            </div>
            <div class="dashboard-card-body">
                <pre style="max-height: 300px; overflow-y: auto; background: #1e1e1e; color: #d4d4d4; padding: 1rem; border-radius: 4px; font-size: 0.85rem;"><?php echo e(json_encode($error->context, JSON_PRETTY_PRINT)); ?></pre>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <div class="col-md-4">
        
        <div class="dashboard-card mb-4">
            <div class="dashboard-card-header">
                <h3>Actions</h3>
            </div>
            <div class="dashboard-card-body">
                <div class="quick-actions">
                    <?php if(!$error->is_resolved): ?>
                    <button type="button" class="quick-action-btn" onclick="resolveError()">
                        <i class="fas fa-check"></i>
                        <span>Mark as Resolved</span>
                    </button>
                    <?php endif; ?>

                    <?php if(!$error->is_sent): ?>
                    <button type="button" class="quick-action-btn" onclick="sendToSupport()">
                        <i class="fas fa-paper-plane"></i>
                        <span>Send to Support</span>
                    </button>
                    <?php endif; ?>

                    <a href="<?php echo e(route('admin.errors.download', $error)); ?>" class="quick-action-btn">
                        <i class="fas fa-download"></i>
                        <span>Download JSON</span>
                    </a>

                    <button type="button" class="quick-action-btn text-danger" onclick="deleteError()">
                        <i class="fas fa-trash"></i>
                        <span>Delete Error</span>
                    </button>
                </div>
            </div>
        </div>

        
        <?php if($error->user): ?>
        <div class="dashboard-card mb-4">
            <div class="dashboard-card-header">
                <h3>User Information</h3>
            </div>
            <div class="dashboard-card-body">
                <div class="mb-3">
                    <img src="<?php echo e($error->user->avatar); ?>" alt="<?php echo e($error->user->name); ?>" style="width: 50px; height: 50px; border-radius: 50%;">
                </div>
                <div class="form-group">
                    <label><strong>Name:</strong></label>
                    <div><?php echo e($error->user->name); ?></div>
                </div>
                <div class="form-group">
                    <label><strong>Email:</strong></label>
                    <div><?php echo e($error->user->email); ?></div>
                </div>
                <div class="form-group">
                    <label><strong>ID:</strong></label>
                    <div><?php echo e($error->user->id); ?></div>
                </div>
                <a href="<?php echo e(route('admin.users.show', $error->user)); ?>" class="btn btn-sm btn-primary w-100">
                    <i class="fas fa-user"></i> View User Profile
                </a>
            </div>
        </div>
        <?php else: ?>
        <div class="dashboard-card mb-4">
            <div class="dashboard-card-header">
                <h3>User Information</h3>
            </div>
            <div class="dashboard-card-body text-center">
                <i class="fas fa-user-slash" style="font-size: 2rem; opacity: 0.5;"></i>
                <p class="mt-2 mb-0">Guest User</p>
            </div>
        </div>
        <?php endif; ?>

        
        <?php if($similarErrors->count() > 0): ?>
        <div class="dashboard-card">
            <div class="dashboard-card-header">
                <h3>Similar Errors (<?php echo e($similarErrors->count()); ?>)</h3>
            </div>
            <div class="dashboard-card-body">
                <div class="list-group">
                    <?php $__currentLoopData = $similarErrors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $similar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a href="<?php echo e(route('admin.errors.show', $similar)); ?>" class="list-group-item list-group-item-action" style="background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); margin-bottom: 0.5rem; border-radius: 4px; color: inherit; text-decoration: none; display: block; padding: 0.75rem;">
                        <div class="d-flex justify-content-between align-items-center">
                            <div style="flex: 1; min-width: 0;">
                                <div style="font-size: 0.9rem; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;">
                                    <?php echo e($similar->short_message); ?>

                                </div>
                                <small class="text-muted"><?php echo e($similar->created_at->diffForHumans()); ?></small>
                            </div>
                            <span class="status-badge status-<?php echo e($similar->level_color); ?> ml-2">
                                <?php echo e(strtoupper($similar->level)); ?>

                            </span>
                        </div>
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function resolveError() {
    if (!confirm('Mark this error as resolved?')) return;

    fetch('<?php echo e(route("admin.errors.resolve", $error)); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            showNotification(data.message, 'success');
            setTimeout(() => location.reload(), 1000);
        } else {
            showNotification(data.message, 'error');
        }
    });
}

function sendToSupport() {
    if (!confirm('Send this error report to Siede Studios support dashboard?')) return;

    const btn = event.target.closest('.quick-action-btn');
    const originalHtml = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i><span>Sending...</span>';
    btn.disabled = true;

    fetch('<?php echo e(route("admin.errors.send", $error)); ?>', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(r => r.json())
    .then(data => {
        showNotification(data.message, data.success ? 'success' : 'error');
        if (data.success) {
            setTimeout(() => location.reload(), 1500);
        } else {
            btn.innerHTML = originalHtml;
            btn.disabled = false;
        }
    })
    .catch(error => {
        showNotification('Network error: ' + error.message, 'error');
        btn.innerHTML = originalHtml;
        btn.disabled = false;
    });
}

function deleteError() {
    if (!confirm('Are you sure you want to delete this error log? This action cannot be undone.')) return;

    fetch('<?php echo e(route("admin.errors.destroy", $error)); ?>', {
        method: 'DELETE',
        headers: {
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
        }
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            showNotification(data.message, 'success');
            setTimeout(() => window.location.href = '<?php echo e(route("admin.errors.index")); ?>', 1000);
        } else {
            showNotification(data.message, 'error');
        }
    });
}

function showNotification(message, type) {
    if (window.adminPanel && window.adminPanel.showNotification) {
        window.adminPanel.showNotification(message, type);
    } else {
        alert(message);
    }
}
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/admin/errors/show.blade.php ENDPATH**/ ?>